################################################################################
####                         TALLER PRACTICO                                ####     
####                        BOTANICA DE CAMPO                               ####
##################################################################################
#### El siguiente script contiene algunas de las metodologías más usadas en ####
#### los trabajos de investigación llevados a cabo durante el curso, y tiene ####
#### como objetivo la familiarización tanto con el lenguaje de R, como con   ####
#### las herramientas que tendrán a disposición para poner a prueba sus     ####
#### futuras hipótesis.                                                      ####
##################################################################################

## SETEAMOS NUESTRO ESPACIO DE TRABAJO
#setwd("C:/")
getwd()

## UTIL COMENZAR CON ESTO PARA EVITAR QUE SE UTILICE ANALISIS ANTERIORES
rm(list=ls())

################################################################################
################################################################################
####                        REGRESION LINEAL                                ####
################################################################################
################################################################################

# Queremos saber si existe una relacion entre el porcentaje de agua en el suelo
# y la altura de una planta

#Para esto necesitamos instalar/llamar las librerias que necesitemos
#install.packages("ggplot2")
library(ggplot2)

#Cargamos los datos
datosR <- read.csv("regresion.csv")

#Visualizamos los datos
plot(datosR)
plot(datosR,xlab="agua (%)",ylab="Altura (cm)", pch=8, col=c("red"))

ggplot(datosR) + 
  geom_point(mapping = aes(x = agua, y = altura))

#Regresión
modelo <- lm(agua ~ altura, datosR)
summary(modelo) #p<0.05

#PLOT
plot1 <- ggplot(datosR, aes(x=agua, y=altura))+
  geom_point(size = 2) + 
  ggtitle("agua ~ altura")+ 
  ylab("agua (%)")+
  xlab("altura (cm)")+
  geom_smooth(method = "lm", se = F, linewidth = 1)+
  theme_test()
plot1

## NORMALIDAD DE LOS RESIDUOS
shapiro.test(modelo$resid)

#Chequeo del modelo
par(mfrow=c(2,2))
plot(modelo)

par(mfrow = c(1,1))
################################################################################
################################################################################
####                        ANOVA UNA VIA                                   ####
################################################################################
################################################################################

# UTIL COMENZAR CON ESTO PARA EVITAR UTILIZAR ANALISIS ANTERIORES
rm(list=ls())

#SE MIDIO LA ALTURA DE CIERTA PLANTA EN 5 SITIOS CON DIFERENTES VARIABLES AMBIENTALES 
# Existe una diferencia significativa entre estos sitios?

#Llamar librerias que nos serviran posteriormente
library(car)
library(ggplot2)

#Cargar los datos 
datosA <- read.csv("anova.csv")

#Sitio <- factor(c(rep("A",10),rep("B",10),rep("C",10),rep("D",10),rep(rep("E",10))))
#Altura <- c(80,95,70,75,60,75,50,85,80,55,65,50,75,90,110,70,55,80,95,65,75,95,105,89,97,105,100,99,68,95,55,60,70,75,80,100,85,45,65,50,70,75,80,85,100,45,95,60,50,110)
#datosA <- data.frame(Sitio,Altura)

#VISUALIZACIN DE DATOS
ggplot(data = datosA, aes(x = Sitio, y = Altura, color = Sitio)) +
  geom_boxplot() +
  theme_bw()

#Promedio por sitio
aggregate(Altura ~ Sitio, data = datosA, FUN = mean)

#SUPUESTOS

#normalidad grfica (datos se ajustan a la diagonal)
par(mfrow = c(2,2))
qqnorm(datosA[datosA$Sitio == "A","Altura"], main = "A")
qqline(datosA[datosA$Sitio == "A","Altura"])
qqnorm(datosA[datosA$Sitio == "B","Altura"], main = "B")
qqline(datosA[datosA$Sitio == "B","Altura"])
qqnorm(datosA[datosA$Sitio == "C","Altura"], main = "C")
qqline(datosA[datosA$Sitio == "C","Altura"])
qqnorm(datosA[datosA$Sitio == "D","Altura"], main = "D")
qqline(datosA[datosA$Sitio == "D","Altura"])
par(mfrow = c(1,1))

#normalidad test de hipotesis (>0.05)
shapiro.test(datosA$Altura)

#homoceasticidad (>0.5)
leveneTest(Altura ~ Sitio,datosA)
bartlett.test(Altura~Sitio, datosA)

#####ANOVA 
anova <- aov(Altura ~ Sitio, datosA)
summary(anova) #<0.05

par(mfrow = c(2,2))
plot(anova)
par(mfrow = c(1,1))

#Normalidad de los residuales
shapiro.test(anova$residuals)

#Comparacion entre sitios
TukeyHSD(anova)


################################################################################
################################################################################
####                             NMDS                                       ####
################################################################################
################################################################################

# Limpiar gestor de memoria
rm (list=ls())


library(ggplot2)
library(dplyr)
library(vegan)

###########

quim_data<- read.csv2("datos_lab_agua.csv")

attach(quim_data)

quim_data$pH <- as.numeric(quim_data$pH)
quim_data$OD <- as.numeric(quim_data$OD)

##########Quita una columna

mapocho <- quim_data %>%
  filter(Sitio %in% c("ALTO", "MEDIO", "BAJO"))

mapocho_qui <- mapocho[, -1]


######Realiza NMDS
set.seed(123)

nmds = metaMDS(mapocho_qui, distance = "bray")
nmds

plot(nmds)



####Obtenemos Scores para mas informacion
data.scores <- as.data.frame(scores(nmds)$sites)

data.scores$Sitio = mapocho$Sitio

##### Graficamos nuestro NMDS
NMDS_plot <- ggplot(data.scores, aes(x = NMDS1, y = NMDS2)) + 
  geom_point(size = 4, aes( shape = Sitio, colour = Sitio))+ 
  theme(axis.text.y = element_text(colour = "black", size = 12, face = "bold"), 
        axis.text.x = element_text(colour = "black", face = "bold", size = 12), 
        legend.text = element_text(size = 12, face ="bold", colour ="black"), 
        legend.position = "right", axis.title.y = element_text(face = "bold", size = 14), 
        axis.title.x = element_text(face = "bold", size = 14, colour = "black"), 
        legend.title = element_text(size = 14, colour = "black", face = "bold"), 
        panel.background = element_blank(), panel.border = element_rect(colour = "black", fill = NA, size = 1.2),
        legend.key=element_blank()) + 
  labs(x = "NMDS1", colour = "Sitio", y = "NMDS2", shape = "Sitio")  + 
  scale_colour_manual(values = c("#009E73", "#E69F00", "red")) 

NMDS_plot


# Podemos observar la contribucion de cada variable a cada eje
nmds$species

################################################################################
################################################################################
####                             GBIF                                       ####
################################################################################
################################################################################
# Limpiar gestor de memoria
rm (list=ls())

#Este ejemplo se enfoca en la obtencion de ocurrencias para la especie
#Lithraea caustica y su posterior tratamiento. 

#Para obtener las ocurrencias de GBIF, es necesario
#descargar e instalar el siguiente paquete:

#install.packages("rgbif")
library(rgbif)

#Una vez instalado el paquete podemos acceder a las funciones que contiene
occ <- occ_search(scientificName = "Lithraea caustica", limit = 100)
occ


#Esta funcion entrega un lista, dentro de esta, encontraremos "data"
occ$data

#"data" se puede convertir a formato dataframe, que es el formato de las tablas
#en R
ocurrencias <- as.data.frame(occ$data)

#si se fijan la funcion occ_search entrega demasiadas variables, y no siempre
#vamos a querer usarlas todas, por lo que uno le puede agregar argumentos a la funcion
#para hacerla mas acorde a lo que necesitamos
occ <- occ_search(scientificName = ("Lithraea caustica"), limit = 100, fields = c("decimalLatitude", "decimalLongitude", "scientificName"))
occ$data
ocurrencias <- as.data.frame(occ$data)

#Ahora bien, si se fijan en su tabla hay varias ocurrencias que aparecen como NA
#por eso siempre es necesario limpiarlas
ocurrencias_filtradas <- ocurrencias[!is.na(ocurrencias$decimalLatitude) & !is.na(ocurrencias$decimalLongitude), ]

##Una vez que tengamos las ocurrencias descargadas es util guardarlas en el PC en formato.CSV (EXCEL)
#El archivo se guardara en el directorio de trabajo que hayan definido. 
write.csv2(ocurrencias_filtradas, file = "EjemploBot.csv", row.names = FALSE)

#Tambien podemos trabajar con mapas vectoriales en formato .shp y usarlos
#para nuestros estudios, por ejemplo, si queremos saber que ocurrencias caen dentro
#de los limites de un pais, Region, o cualquier lugar que queramos, podemos hacer lo siguiente.

#Lo primero es descargar e instalar el paquete necesario
#install.packages("sp")
library(sf)

#Cargar un mapa vectorial con la forma santiago
shp <- st_read(file.choose())
plot(shp)

#Se necesita cambiar su sistema de referencia para hacerlo compatible con las ocurrencias
shp_transformado <- st_transform(shp, crs = 4326)

#Luego se necesita transformar el formato de las ocurrencias para hacer la intersecci???n
ocurrenciassf <- st_as_sf(ocurrencias_filtradas, coords = c("decimalLongitude", "decimalLatitude"), crs = 4326)
ocurrencias_dentro_de_shp <- st_intersection(ocurrenciassf, shp_transformado)

##Tambien podemos graficar estas ocurrencias 
ggplot() +
  geom_sf(data = shp_transformado, fill = "white", color = "black") +  # Mapa de Santiago
  geom_sf(data = ocurrencias_dentro_de_shp, color = "red", size = 1.5) +  # Ocurrencias
  labs(title = "Ocurrencias en Santiago")

#Si se fijan, tambien podemos guardar este grafico en formato PDF##############################



################################################################################
################################################################################
####                             MAXENT                                     ####
################################################################################
################################################################################
# Limpiar gestor de memoria
rm (list=ls())
#install.packages("dismo") 
#install.packages("raster")
#install.packages("rgdal")
#install.packages("rJava")

######################################################################################
library(raster)
library(dismo)
library(rgdal)
library(rJava)
library(tidyverse)
options(java.parameters = "-Xmx1g" )#es para que Ruse 1gb de Ram, y acelere los procesos

#Setear el directorio de trabajo, 
#Ahora podemos cargar archivos desde ahi mismo en la pesta???a files
list.files()
occs<-read.csv("nothofagus_subgenus.csv")

#occs debe tener otros nombres
occs1<-data.frame(decimalLongitude=occs$Longitude, decimalLatitude=occs$Latitude)

bio <- getData("worldclim", var = "bio", res = 10) 
bio

# Obtiene la lista de nombres de las capas en el raster stack
layer_names <- names(bio)

# Crea un loop para separar cada raster en un objeto individual
for (layer_name in layer_names) {
  # Obtiene el raster de la capa actual
  current_raster <- bio[[layer_name]]
  
  # Asigna el raster a un objeto con el nombre de la capa
  assign(layer_name, current_raster)
}

#crear nuevo stack con variables a trabajar
CapasRaster <- stack(bio1, bio11, bio12, bio19)

e <- extent(-85,-35,-60,10)
SUD <- crop(CapasRaster,e)
plot(SUD)

e_au <- extent(110, 160, -50, -10)
AU <- crop(CapasRaster,e_au)
plot(AU)

#Para ver en la consola las caracteristicas de nuestro Stack
CapasRaster

#Corre el modelo
m<-maxent(CapasRaster, occs1)
m

#Background del area de estudio
presencias<-extract(CapasRaster, occs1, cellnumbers=T)
View(presencias)
presencias<-na.omit(presencias)#quita valores NA
presencias<-unique(presencias) #quita valores repetidos
presencias<-presencias[,-1]#quita la primera columna

#bkg<-sampleRandom(CapasRaster,10000,cells=T) #Lanza 10000 puntos aleatorios en el area de estudio con valores que no son NA
bkg <- dismo :: randomPoints(CapasRaster,n = 10000) %>% as.data.frame()
colnames(bkg) <- colnames(occs[,-1])
plot(CapasRaster$bio1)
points(bkg, pch = 20, cex = 0.2)

set.seed(1)
selected <- sample(1:nrow(occs[,-1]),nrow(occs[,-1]) * 0.25)

occ_fin <- occs1
occ_train <- occ_fin[selected, ]
occ_test <- occ_fin[-selected, ]

plot(CapasRaster$bio1)
points(occ_train, pch = 20, cex = 0.2)
points(occ_test, pch = 20, cex = 0.2)

detach("package:tidyverse", unload = T)
detach("package:tidyr", unload = T)

p <- extract(CapasRaster, occ_train)
p_test <- extract(CapasRaster, occ_test)
p_bkg <- extract(CapasRaster, bkg) 

pbkg <- c(rep(1,nrow(p)),rep(0, nrow(p_bkg)))

pder <- as.data.frame(rbind(p,p_bkg))

mod <- maxent(x = pder, p = pbkg, args = c("responsecurves"))
mod

mod@results


#predecir
pet1 <- predict(mod,SUD)
plot(pet1)

Pet2 <- predict(mod, AU)
plot(Pet2)

################################################################################
################################################################################
####                  CALIBRAR Y PODAR ARBOL FILOGENETICO                   ####
################################################################################
################################################################################

# Limpiar gestor de memoria
rm (list=ls())

####FILOGENIA
library(geiger)
#install.packages("ape")
#library(ape)

list.files()
Notho_tree1 <- read.tree(file="arbol_mod_1.txt")#lee el arbol
#x11()
plot(Notho_tree1)#lo grafica

#muchas veces se necesita "calibrar" los arboles filogeneticos
nodelabels() #le pone numeros a los nodos para identificarlos
chrono_Notho1<-chronopl(Notho_tree1,0,age.min=c(95.1, 81.6, 50.7, 71.9,57.6,47.7,45.9), age.max=NULL,node=c(28, 34, 29, 40,35,45,44), S= 1, tol= 1e-20, CV=FALSE, eval.max=500,iter.max= 500)#se calibra el arbol
x11()
plot(chrono_Notho1)
plot(chrono_Notho1, edge.width = 2, label.offset = 0.1, type = "cladogram")
axisPhylo()#le agrega la linea de tiempo

#tambien podemos "podar" los aeboles filogeneticos
chrono_Notho1$tip.label #"accede a las etiquetas de las ramas del arbol"
species<-c("N_bet",    "N_nit",    "N_ant",    "N_dom", "N_pum" ) #subg nothofagus
pruned.tree<-drop.tip(chrono_Notho1,chrono_Notho1$tip.label[-match(species, chrono_Notho1$tip.label)]) #corta las especies definidas en el objeto "species"
plot(pruned.tree)
plot(pruned.tree, edge.width = 2, label.offset = 0.1, type = "cladogram")

nodelabels()
chrono_pruned<-chronopl(pruned.tree,0,age.min=c(57.6, 45.9), age.max=NULL,node=c(6,9), S= 1, tol= 1e-20, CV=FALSE, eval.max=500,iter.max= 500)
plot(chrono_pruned)
axisPhylo()

################################################################################
#FIN

